
#include "CEgFileSpec.h"
#include "MacAMP_Visual.h"
#include "WhiteCap.h"
#include "EgOSUtils.h"
#include <Dialogs.h>
#include <Resources.h>
#include <stdlib.h>
#include <time.h>

// This is the gPlugInfo block - a place where MacAmp gets initial information about your plugin.
// Make sure to set the fragment's entry point to gPlugInfo to make it accessible for the MacAmp routines.

VPInfoBlock gPlugInfo =
{
	VP_INFOBLOCK_HEADER( cPluginAuthor, cWhiteCapID),

	"\pWhiteCap",

	VisInitialize,
	VisTerminate,
	nil,				// we don't idle
	VisAbout,
	VisDraw,
	VisClick,
	
	nil,			// we don't want keydowns..
	VisMacEvent,		// ...and events
	
	nil,
	nil,				// we have no settings
	nil,
	nil,
	
	// Nifty macro to set all these 'reserved' values for us
	VP_INFOBLOCK_FOOTER
};




// These are globals.
static WhiteCap*		gWC = NULL;
static float			gSample[ NUM_SAMPLE_BINS ];
static short			gRefNum = -1;
static double			gDummyFFT[ NUM_SAMPLE_BINS ];



/* 
	PlugInitialize

	Called every time use selects your plugin from the Plugins menu. You need to allocate and display a window here,
	init your variables, and do whatever you want, like set the refnum if you need it.
	
	This function uses FSSpec to itself that MacAmp provides to it to gain access to its resource fork.
	
	Other than that, everything is hard-coded and is definitly not an example of good programming =P
*/
OSStatus	VisInitialize(FSSpecPtr inPlugin, WindowPtr* outWindow, UInt32* ) {
	
	gRefNum = ::FSpOpenResFile( inPlugin, fsRdPerm );

	EgOSUtils::Initialize();
	PixPort::Startup();
		
		
	Rect r = { 0, 0, 0, 0 };
	*outWindow = ::NewCWindow( NULL, &r, "\pWhiteCap", false, 1985, (WindowPtr)-1, true, NULL );
	CEgFileSpec folder;
	folder.AssignFolder( "WhiteCap Configs" );
	
	
	gWC = new WhiteCap( folder );
	gWC -> SetWinPort( *outWindow );

	
	// Update the window
	gWC -> Draw();

	return noErr;
}


/* 
	PlugTerminate

	Called when user deselects your plugin, MacAmp quits or in the case if you have passed visTerminate/visNoMemory error.
	You should dispose your window here & clean up the mess.
*/
OSStatus	VisTerminate(WindowPtr inWin, UInt32*)
{

	delete gWC;
	gWC = NULL;


	::DisposeWindow( inWin );
	
	PixPort::Shutdown();

		
	// Close our resource fork.
	if ( gRefNum != -1 )
		::FSClose( gRefNum );
	
	return noErr;
}



OSStatus VisDraw(WindowPtr, UInt32*) { 

	// If we detext a click in fullscreen, then exit fullscreen mode no matter what
	if ( gWC -> IsFullScreen() ) {
		if ( ::Button() )
			gWC -> SetFullScreen( false ); 
	}
	
	int i, j, bin;
	unsigned long time, status = 0;
	unsigned short fftNum;
	double* samp;
	

	gPlugInfo.ma->GetFFT( &samp, &fftNum );

	if ( gPlugInfo.ma->GetStatus )
		gPlugInfo.ma->GetStatus( &time, &status );

	if ( fftNum < NUM_SAMPLE_BINS * 11 + 10 || ( status & statusStopped ) ) {
		for ( i = 0; i < NUM_SAMPLE_BINS; i++ ) {
			gSample[ i ] = 0; 
		} }
	else {
	
		bin = 10;
		for ( i = 0; i < NUM_SAMPLE_BINS; i++ ) {
			gSample[ i ] = 0;
			for ( j = 0; j < 8; j++, bin++ ) 
				gSample[ i ] += samp[ bin ];
		}
		
		bin = 10;
		for ( i = 0; i < NUM_SAMPLE_BINS; i++ ) {
			for ( j = 0; j < 8; j++, bin++ ) 
				gSample[ i ] += samp[ bin ];
//			gSample[ i ] = .03 * .0003 * gSample[ i ] * (0.85 + .059 * i);
//			gSample[ i ] = .1 * ( sqrt( 15 + .0003 * gSample[ i ] * (0.85 + .059 * i) ) - sqrt( 15 ) );

			gSample[ i ] = .12 * ( sqrt( 40 + .00042 * gSample[ i ] * (0.85 + .051 * i) ) - sqrt( 40 ) );
			
			
			//gSample[ i ] = .000013 * gSample[ i ] * (0.85 + .058 * i);
			//gSample[ i ] = 1 * log( 2 * gSample[ i ] + 1 );

			//gSample[ i ] = pow( gSample[ i ], 1.4 );
			//gSample[ i ] = log( 1 + .6 * gSample[ i ] );

		}
		
		gSample[ 0 ] *= 0.45;
		gSample[ 1 ] *= 0.75;
		
		//gSample[ 4 ] = 1;
	}

	// Store the newest sample and chuck and old samples
	gWC -> RecordSample( EgOSUtils::CurTimeMS(), gSample );

	// Update the screen, baby.  Let's shag!
	gWC -> Draw();
	
	return noErr;

}


OSStatus VisClick( WindowPtr inWindow, Point inPt, UInt32* ) {
	static long sLastWhen = 0;
	long 	curTime = ::TickCount();
	bool	doSelect = false;
	bool	button = ::Button();
	
	// see if the cmd key is down
	if ( button ) {
		unsigned char km[16];
		::GetKeys( (unsigned long*) km );
		long code = 55;	 // Cmd key code
		if ( ((km[ code >> 3 ] >> (code & 7)) & 1) != 0 ) {
			doSelect = true;
		}
	}
	
	if ( gWC -> PtInTitle( inPt ) || doSelect )
		gWC -> SelectConfig();
	else if ( curTime - sLastWhen < ::GetDblTime() ) 
		gWC -> SetFullScreen( true );
	else if ( ! gWC -> IsFullScreen() ) {
		if ( button ) {
			Rect r, growBox, lim;
			gWC -> GetWinRect( r );
			growBox = r;
			growBox.left = r.right - 30;
			growBox.top = r.bottom - 30;
			if ( ::PtInRect( inPt, &growBox ) ) {
				lim.top = lim.left = 30;
				lim.bottom = lim.right = 9000;
				unsigned long newSize = ::GrowWindow( inWindow, inPt, &lim );
				::SizeWindow( inWindow, newSize & 0xFFFF, newSize >> 16, false );
				gWC -> GetWinRect( r );
				gWC -> SetWinPort( inWindow, &r );		// SizeWindow changes the size of the win, but gWC doesn't know that
			}
		}
		sLastWhen = curTime;
	}

	return noErr;
}



OSStatus VisMacEvent(WindowPtr inWindow, EventRecord* inEvt, UInt32* ) {
	
	switch ( inEvt -> what ) {
		case updateEvt:	
			::BeginUpdate( inWindow );
			gWC -> RefreshRect( (**( inWindow -> visRgn)).rgnBBox );
			::EndUpdate( inWindow );
			gWC -> Draw(); 
			break;
			
		/*	
		case mouseDown:	
			if ( ::Button() && ( inEvt -> modifiers & cmdKey ) )
				gWC -> SelectConfig();
			break;*/
	}


	return noErr;
}
/*


OSStatus VisClick(WindowPtr window, Point inPt, UInt32* )
{
	static long sLastWhen = 0;
	long 	curTime = ::TickCount();
	//OSErr	result = noErr;
	
		if ( false )
			gWC -> SelectConfig( inPt.h, inPt.v );
		else if ( gWC -> IsAtFullScreen() )
			gWC -> SetFullScreen( false );
		else if ( curTime - sLastWhen < ::GetDblTime() ) 
			gWC -> SetFullScreen( true );
		else {
			if ( ::Button() ) {
				Rect r, growBox, lim;
				gWC -> GetWinRect( r );
				growBox = r;
				growBox.left = r.right - 20;
				growBox.top = r.bottom - 20;
				if ( ::PtInRect( inPt, &growBox ) ) {
					lim.top = lim.left = 30;
					lim.bottom = lim.right = 9000;
					unsigned long newSize = ::GrowWindow( window, inPt, &lim );
					::SizeWindow( window, newSize & 0xFFFF, newSize >> 16, false );
					gWC -> GetWinRect( r );
					gWC -> SetWinRect( r );		// SizeWindow changes the size of the win, but gWC doesn't know that
					gWC -> ResizeWorlds( r );
				}
				else {
					r.top = r.left = 0;
					r.bottom = r.right = 9000;
					::DragWindow(window, inPt, &r);
				}
			}
			sLastWhen = curTime;
		}
		/*
						break;
				}
				
			}
			break;
			
		default:
			break;
	}
	return noErr;
}

*/


OSStatus	VisAbout(WindowPtr, UInt32*)
{
	::NoteAlert( 556, nil );
	return noErr;
}






/* 
	PlugSettings

	Called when user selects your plugin from the Settings submenu. Only used if you have declared that
	you support settings (flagHasSettings is set).
	
	You should display the settings dialog here, or do whateverr you feel like. =) Just remember that when user
	chooses settings (s)he expects some interactino with the plugin, like the dialog or like that.
*/
OSStatus VisSettings(WindowPtr inWindow, UInt32* ioRefcon) {

#pragma unused (inWindow, ioRefcon)
	return noErr;
}










#ifdef MACAMP

/* 

*****  Everything below here is for a project that runs on its own.  

Essential when you need to debug, etc
-ACO 1/14/99

*/

#include <Types.h>
#include <Memory.h>
#include <Quickdraw.h>
#include <Fonts.h>
#include <Events.h>
#include <Menus.h>
#include <Windows.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <OSUtils.h>
#include <ToolUtils.h>
#include <SegLoad.h>
#include <Sound.h>

	
/* Prototypes */
void Initialize(void);

// 
//	Main body of program SillyBalls
//
#include "Expression.h"
#include "Hashtable.h"




void dummyGetFFT( double** outFFT, UInt16* outFFTSize );

void dummyGetFFT( double** outFFT, UInt16* outFFTSize ) {
	*outFFT = gDummyFFT;
	*outFFTSize = 0;
}

//MW specified argument and return type.
int main(void)
{
	GrafPort win;
	WindowPtr winP = &win;
	unsigned long	num, N = NUM_SAMPLE_BINS;
	FSSpec spec;

	for ( num = 0; num < N; num++ )
		gDummyFFT[ num ] = 0;
	
	Initialize();
	gPlugInfo.ma = new VPCallbacks;
	gPlugInfo.ma -> GetFFT = dummyGetFFT;
	gPlugInfo.ma -> GetStatus = NULL; 
	gPlugInfo.ma -> EnterFullScreen = NULL;
	gPlugInfo.ma -> ExitFullScreen = NULL;
	
	VisInitialize( &spec, &winP, &num );

	
	do {
		VisDraw( winP, &num );
		long n = EgOSUtils::Rnd( 0, N-1 );
		gDummyFFT[ n ] += .011 * EgOSUtils::Rnd( 0, 100 );
		for ( num = 0; num < N; num++ ) {
			gDummyFFT[ num ] = .8 * gDummyFFT[ num ];
		}
	} while (!Button());

	VisTerminate( winP, &num );
	
	delete gPlugInfo.ma;
	
	return 0;	
}


// 
//	Initialize everything for the program, make sure we can run
//

//MW specified argument and return type.
void Initialize(void)
{
	OSErr		error;
	SysEnvRec	theWorld;
		
	//
	//	Test the computer to be sure we can do color.  
	//	If not we would crash, which would be bad.  
	//	If we cant run, just beep and exit.
	//

	error = SysEnvirons(1, &theWorld);
	if (theWorld.hasColorQD == false) {
		SysBeep(50);
		ExitToShell();					/* If no color QD, we must leave. */
	}
	
	/* Initialize all the needed managers. */
	InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	InitCursor();

	//
	//	To make the Random sequences truly random, we need to make the seed start
	//	at a different number.  An easy way to do this is to put the current time
	//	and date into the seed.  Since it is always incrementing the starting seed
	//	will always be different.  Dont for each call of Random, or the sequence
	//	will no longer be random.  Only needed once, here in the init.
	//
	GetDateTime((unsigned long*) &qd.randSeed);

}


#endif
